/*
 ************************************************************************************************
 *                                                                                              *
 *  OSA cooperative RTOS for Microchip PIC-controllers: PIC10/12/16/18/24/dsPIC                 *
 *                                                                                              *
 *  URL:            http://wiki.pic24.ru/doku.php/en/osa/ref/intro                              *
 *                  http://picosa.narod.ru                                                      *
 *                                                                                              *
 *----------------------------------------------------------------------------------------------*
 *                                                                                              *
 *  File:           osa_flag.h                                                                  *
 *                                                                                              *
 *  Compilers:      HT-PICC STD                                                                 *
 *                  HT-PICC18 STD                                                               *
 *                  Microchip C18                                                               *
 *                  Microchip C30                                                               *
 *                                                                                              *
 *  Programmer:     Timofeev Victor                                                             *
 *                  osa@pic24.ru, testerplus@mail.ru                                            *
 *                                                                                              *
 *  Description:    Services for work with flags                                                *
 *                                                                                              *
 *  History:        21.01.2009                                                                  *
 *                                                                                              *
 ************************************************************************************************
 */





/************************************************************************************************/
/*                                                                                              */
/*                     F L A G S                                                                */
/*                                                                                              */
/************************************************************************************************/

//------------------------------------------------------------------------------
// Create flags and clear all bits

#define OS_Flag_Create(flags)                flags = 0


//------------------------------------------------------------------------------
// Set flags to given value

#define OS_Flag_Init(flags, value)           flags = value


//------------------------------------------------------------------------------
// Set bits in flag by given mask

#define OS_Flag_Set_1(flags, mask)             flags |= mask


//------------------------------------------------------------------------------
// Clear bits in flag by given mask

#define OS_Flag_Set_0(flags, mask)           flags &= ~(mask)


//------------------------------------------------------------------------------
// Check for all bits in flag are set by given mask

#define OS_Flag_Check_11(flags, mask)        (((flags) & (mask))==(mask))


//------------------------------------------------------------------------------
// Check for any bit in flag is set by given mask

#define OS_Flag_Check_1x(flags, mask)        ((flags) & (mask))


//------------------------------------------------------------------------------
// Check for bits in flag are cleared by given mask

#define OS_Flag_Check_00(flags, mask)   (((flags) & (mask)) == 0)


//------------------------------------------------------------------------------
// Check for any bit in flag is cleared by given mask

#define OS_Flag_Check_0x(flags, mask)   (((flags) & (mask)) != (mask))


//------------------------------------------------------------------------------
// Wait for all bits in flags are set by given mask

#define OS_Flag_Wait_11(flags, mask)                                    \
    {                                                                   \
        _OS_WAIT_EVENT(OS_Flag_Check_11(flags, mask));                  \
    }


//------------------------------------------------------------------------------
// Wait for any bit in flags is set by given mask

#define OS_Flag_Wait_1x(flags, mask)                                    \
    {                                                                   \
        _OS_WAIT_EVENT(OS_Flag_Check_1x(flags, mask));                  \
    }


//-------------------------------------------------------------------------------
// Wait for all bits in flags are set by given mask. Exit if timeout expired.

#define OS_Flag_Wait_11_TO(flags, mask, timeout)                        \
    {                                                                   \
        _OS_WAIT_EVENT_TIMEOUT(OS_Flag_Check_11(flags, mask), timeout); \
    }


//-------------------------------------------------------------------------------
// Wait for any bit in flags is set by given mask. Exit if timeout expired.

#define OS_Flag_Wait_1x_TO(flags, mask, timeout)                        \
    {                                                                   \
        _OS_WAIT_EVENT_TIMEOUT(OS_Flag_Check_1x(flags, mask), timeout); \
    }


//------------------------------------------------------------------------------
// Wait for all bits in flag are cleared by given mask

#define OS_Flag_Wait_00(flags, mask)                                    \
    {                                                                   \
        _OS_WAIT_EVENT(OS_Flag_Check_00(flags, mask));                  \
    }


//------------------------------------------------------------------------------
// Wait for any bit in flag is cleared by given mask

#define OS_Flag_Wait_0x(flags, mask)                                    \
    {                                                                   \
        _OS_WAIT_EVENT(OS_Flag_Check_0x(flags, mask));                  \
    }


//-------------------------------------------------------------------------------
// Wait for all bits in flag are cleared by given mask. Exit if timeout expired.

#define OS_Flag_Wait_00_TO(flags, mask, timeout)                        \
    {                                                                   \
        _OS_WAIT_EVENT_TIMEOUT(OS_Flag_Check_00(flags, mask), timeout); \
    }

//-------------------------------------------------------------------------------
// Wait for any bit in flag is cleared by given mask. Exit if timeout expired.

#define OS_Flag_Wait_0x_TO(flags, mask, timeout)                        \
    {                                                                   \
        _OS_WAIT_EVENT_TIMEOUT(OS_Flag_Check_0x(flags, mask), timeout); \
    }




















