#include <pic.h>
#include <OSA.h>

unsigned char counter;

OST_QUEUE    queue;

OST_MSG buf[5];

//------------------------------------------------------------------------------
void Task_T1 (void)
{
    OST_MSG     msg;
    for (;;)
    {
        counter++;
        OS_Yield();
        counter++;
        OS_Queue_Send(queue, msg);
    }
}


//------------------------------------------------------------------------------
void Task_T2 (void)
{
    OST_MSG     msg;
    for (;;)
    {
        counter++;
        OS_Yield();
        counter++;
        OS_Queue_Wait(queue, msg);
    }
}


//------------------------------------------------------------------------------
void Task_T3 (void)
{
    OST_MSG     msg;
    for (;;)
    {
        counter++;
        OS_Yield();
        counter++;
        OS_Queue_Wait_TO(queue, msg, 100);
    }
}


//------------------------------------------------------------------------------
void main (void)
{
    OS_Init();
    OS_Task_Create(1, Task_T1);
    OS_Task_Create(1, Task_T2);
    OS_Task_Create(1, Task_T3);

    OS_Queue_Create(queue, buf, 5);

    for (;;)
    {
        asm(" CLRWDT ");
        OS_Timer();
        OS_Sched();
    }
}

